﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ldn/detail/ldn_Config.h>
#include <nn/ldn/ldn_PrivateResult.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>

/**
 * @def           NN_LDN_ASSERT_RESULT_SUCCESS
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 * @details       Debug, Develop ビルドでは NN_ABORT_UNLESS_RESULT_SUCCESS と同じ挙動です。
 *                Release ビルドでは何もしません。
 */
#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    #define NN_LDN_ASSERT_RESULT_SUCCESS(result) NN_ABORT_UNLESS_RESULT_SUCCESS(result)
#else
    #define NN_LDN_ASSERT_RESULT_SUCCESS(result)
#endif

/**
 * @def           NN_LDN_REQUIRES
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 * @details       Debug, Develop ビルドでは NN_SDK_REQUIRES と同じ挙動です。
 *                Release ビルドでは nn::ldn::ResultBadRequest を return します。
 */
#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    #define NN_LDN_REQUIRES(cond) NN_SDK_REQUIRES(cond)
#else
    #define NN_LDN_REQUIRES(cond) NN_RESULT_THROW_UNLESS(cond, ::nn::ldn::ResultBadRequest())
#endif

/**
 * @def           NN_LDN_REQUIRES_FALSE
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_FALSE(cond) NN_LDN_REQUIRES(!(cond))

/**
 * @def           NN_LDN_REQUIRES_EQUAL
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_EQUAL(lhs, rhs) NN_LDN_REQUIRES((lhs) == (rhs))

/**
 * @def           NN_LDN_REQUIRES_NOT_EQUAL
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_NOT_EQUAL(lhs, rhs) NN_LDN_REQUIRES((lhs) != (rhs))

/**
 * @def           NN_LDN_REQUIRES_NULL
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_NULL(var) NN_LDN_REQUIRES((var) == nullptr)

/**
 * @def           NN_LDN_REQUIRES_NOT_NULL
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_NOT_NULL(var) NN_LDN_REQUIRES((var) != nullptr)

/**
 * @def           NN_LDN_REQUIRES_MINMAX
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_MINMAX(var, start, last)\
    NN_LDN_REQUIRES((start) <= (var) && (var) <= (last))

/**
 * @def           NN_LDN_REQUIRES_RANGE
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_RANGE(var, begin, end)\
    NN_LDN_REQUIRES((bebin) <= (var) && (var) < (end))

/**
 * @def           NN_LDN_REQUIRES_INCLUDE
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_INCLUDE(var, ...) NN_LDN_REQUIRES(NN_LDN_INCLUDE(var, __VA_ARGS__))

/**
 * @def           NN_LDN_REQUIRES_NOT_INCLUDE
 * @brief         クライアントからの要求に対する事前条件の検証を行います。
 */
#define NN_LDN_REQUIRES_NOT_INCLUDE(var, ...) NN_LDN_REQUIRES(!NN_LDN_INCLUDE(var, __VA_ARGS__))

#define NN_DETAIL_LDN_EXPAND(x) x
#define NN_DETAIL_LDN_GET_NAME(a1, a2, a3, a4, a5, a6, a7, a8, a9, name, ...) name
#define NN_DETAIL_LDN_INCLUDE1(var, n1) ((var) == (n1))
#define NN_DETAIL_LDN_INCLUDE2(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE1(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE3(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE2(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE4(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE3(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE5(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE4(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE6(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE5(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE7(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE6(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE8(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE7(var, __VA_ARGS__)))
#define NN_DETAIL_LDN_INCLUDE9(var, n1, ...)\
    (NN_DETAIL_LDN_INCLUDE1(var, n1) || \
     NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_INCLUDE8(var, __VA_ARGS__)))
#define NN_LDN_INCLUDE(var, ...) NN_DETAIL_LDN_EXPAND(NN_DETAIL_LDN_GET_NAME(\
    __VA_ARGS__,\
    NN_DETAIL_LDN_INCLUDE9,\
    NN_DETAIL_LDN_INCLUDE8,\
    NN_DETAIL_LDN_INCLUDE7,\
    NN_DETAIL_LDN_INCLUDE6,\
    NN_DETAIL_LDN_INCLUDE5,\
    NN_DETAIL_LDN_INCLUDE4,\
    NN_DETAIL_LDN_INCLUDE3,\
    NN_DETAIL_LDN_INCLUDE2,\
    NN_DETAIL_LDN_INCLUDE1)(var, __VA_ARGS__))
