﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/ldn_NetworkId.h>
#include <nn/ldn/detail/ldn_Version.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         Advertis データを構築するインタフェースです。
     */
    class IAdvertiseBuilder
    {
    public:

        /**
         * @brief         デストラクタです。
         */
        virtual ~IAdvertiseBuilder() NN_NOEXCEPT
        {
        }

        /**
         * @brief         NetworkId を設定します。
         *
         * @param[in]     networkId     NetworkId です。
         */
        virtual void SetNetworkId(const NetworkId& networkId) NN_NOEXCEPT = 0;

        /**
         * @brief         プロトコル・バージョンを設定します。
         *
         * @param[in]     version       プロトコル・バージョンです。
         */
        virtual void SetVersion(Version version) NN_NOEXCEPT = 0;

        /**
         * @brief         Advertise データを構築します。
         *
         * @param[out]    pOutAdvertise Advertise の出力先です。
         * @param[out]    pOutSize      出力サイズです。
         * @param[in]     bufferSize    pOutAdvertise のバッファサイズです。
         * @param[in]     data          Advertise に載せて配信するデータです。
         * @param[in]     dataSize      data のバイトサイズです。
         *
         * @return        Advertise データのサイズです。
         *
         * @pre
         *                - NetworkId が設定済であること
         *                - Version が設定済であること
         *                - pOutAdvertise != nullptr
         *                - pOutSize != nullptr
         *                - data != nullptr
         *                - dataSize <= AdvertiseBodySizeMax
         */
        virtual void Build(
            void* pOutAdvertise, size_t* pOutSize, size_t bufferSize,
            const void* data, size_t dataSize) NN_NOEXCEPT = 0;
    };

}}} // end of namespace nn::ldn::detail
