﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/detail/lcs_ApplicationShareInfo.h>
#include <nn/lcs/detail/lcs_SystemShareInfo.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/ns/ns_Async.h>
#include <nn/ns/ns_SystemUpdateApi.h>

namespace nn { namespace lcs { namespace detail
{

    Result GetSystemDeliveryInfo(SystemDeliveryInfo *pOutInfo) NN_NOEXCEPT;

    Result VerifyDeliveryProtocolVersion(const SystemDeliveryInfo& sysInfo) NN_NOEXCEPT;

    Result CompareSystemDeliveryInfo(int* pOutValue,
        const SystemDeliveryInfo& lhs, const SystemDeliveryInfo& rhs) NN_NOEXCEPT;

    Result SelectLatestSystemDeliveryInfo(
        int* outValue, const SystemDeliveryInfo* list, int listCount,
        const SystemDeliveryInfo& receiverSystemInfo,
        const ApplicationDeliveryInfo* receiveAppInfoList, int appInfoListCount) NN_NOEXCEPT;

    Result SelectLatestSystemDeliveryInfo(
        int* outValue, const SystemDeliveryInfo* list, int listCount,
        const SystemDeliveryInfo& receiverSystemInfo) NN_NOEXCEPT;

    Result RequestReceiveSystemUpdate(
        nn::ns::AsyncResult* asyncResult, Ipv4Address fromAddress, uint16_t port,
        const SystemDeliveryInfo& info,
        nn::ns::SystemUpdateControl* systemUpdateControl) NN_NOEXCEPT;

    void GetReceiveSystemUpdateProgress(uint64_t* downloadedSize, uint64_t* totalSize,
        nn::ns::SystemUpdateControl* systemUpdateControl) NN_NOEXCEPT;

    Result GetDownloadedEulaDataSize(size_t* size, const char* eulaDataPath,
        nn::ns::SystemUpdateControl* systemUpdateControl) NN_NOEXCEPT;

    Result GetDownloadedEulaData(size_t* size, void* buffer, size_t bufferSize,
        const char* eulaDataPath, nn::ns::SystemUpdateControl* systemUpdateControl) NN_NOEXCEPT;

    bool ApplyReceivedUpdate(nn::ns::SystemUpdateControl* systemUpdateControl) NN_NOEXCEPT;

    Result RequestSendSystemUpdate(nn::ns::AsyncResult* asyncResult,
        Ipv4Address toAddress, uint16_t port, const SystemDeliveryInfo& info) NN_NOEXCEPT;

    void GetSendSystemUpdateProgress(uint64_t* deliveredSize, uint64_t* totalSize) NN_NOEXCEPT;

    void ShowSystemDeliveryInfo(const SystemDeliveryInfo& info) NN_NOEXCEPT;

}}} // end of namespace nn::lcs
