﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/ldn/ldn_PrivateTypes.h>

namespace nn { namespace lcs { namespace detail
{

    struct ResumeContext
    {
        uint8_t                     lcsRole;
        uint8_t                     contentsCount;
        uint8_t                     entryCount;
        uint8_t                     _reserved1;
        Ipv4Address                 hostAddress;
        SuspendedReason             suspendedReason;
        uint8_t                     _reserved2[116];
        ContentsInfo                contentsInfo[SharableContentsCountMax + 1];
        uint8_t                     _reserved3[96];
        AddressEntry                addressEntry[NodeCountMax];
        SystemDeliveryInfo          systemDeliveryInfo;
        SessionInfo                 sessionInfo;
        int64_t                     requiredStorageSize;
        uint32_t                    myIndex;
        uint8_t                     appHashCount;
        ApplicationDeliveryInfoHash appHash[SharableContentsCountMax];
        char                        _reserved4[56];
    };
    NN_STATIC_ASSERT(sizeof(ResumeContext) == sizeof(SessionContext));

}}} // namespace nn::lcs::detail
