﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/detail/lcs_NetworkInfo.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/socket.h>

namespace nn { namespace lcs { namespace detail
{

    const int SendRetryCountMax = 100;
    const int SendTimeoutMicroSeconds = 100;

    ssize_t Send(int socket, void* buffer, size_t bufferSize, int flag) NN_NOEXCEPT;

    ssize_t SendApplicationControlDataReq(
        int socket, const ncm::ApplicationId& id, bool isSizeOnly) NN_NOEXCEPT;

    ssize_t SendApplicationControlDataRes(
        int socket, const ncm::ApplicationId& id, size_t dataSize, bool isSizeOnly) NN_NOEXCEPT;

    ssize_t SendApplicationControlData(int socket, void* data, size_t dataSize) NN_NOEXCEPT;

    ssize_t SendJoin(int socket, char* name,
        const Version& lcsVersion, int appCount, size_t appInfoSize) NN_NOEXCEPT;

    ssize_t SendUpdate(int socket, char* name, const Version& lcsVersion, const SystemDeliveryInfo& sysInfo,
        int appCount, int downloadedContentCount, size_t appInfoSize) NN_NOEXCEPT;

    ssize_t SendLeave(int socket, LeaveReason reason) NN_NOEXCEPT;

    ssize_t SendAccept(int socket, uint32_t index) NN_NOEXCEPT;

    ssize_t SendReject(int socket, RejectReason reason) NN_NOEXCEPT;

    ssize_t SendSessionInfoHeader(int socket, int appCount, int nodeCount, size_t packetSize) NN_NOEXCEPT;

    ssize_t SendAppInfo(int socket, const ApplicationInfo& appInfo) NN_NOEXCEPT;

    ssize_t SendAppDeliveryInfo(int socket, const ApplicationDeliveryInfo& deliveryInfo) NN_NOEXCEPT;

    ssize_t SendNodeInfo(int socket, const NodeInfo& nodeInfo) NN_NOEXCEPT;

    ssize_t SendStart(int socket) NN_NOEXCEPT;

    ssize_t SendMigration(int socket, const MigrationInfo& info) NN_NOEXCEPT;

    ssize_t SendSystemShareClearPacket(int socket, SystemUpdateReason reason) NN_NOEXCEPT;

    ssize_t SendSystemShareInfoPacket(int socket, Type type, TransferRole role,
        uint32_t index, Ipv4Address address, const SystemDeliveryInfo& sysInfo, int channel) NN_NOEXCEPT;

    ssize_t SendSystemShareResPacket(int socket, Type type, Response response,
        const SystemDeliveryInfo& sysInfo) NN_NOEXCEPT;

    ssize_t SendContentShareClearPacket(int socket,
        nn::util::BitFlagSet<8, ContentsType> contentsFlag, Bit64 id) NN_NOEXCEPT;

    ssize_t SendContentShareInfoPacket(int socket, Type type,
        TransferRole role, uint32_t index,
        Ipv4Address address, int contentMetaCount, Bit64 id, int channel, size_t packetSize) NN_NOEXCEPT;

    ssize_t SendContentShareResPacket(int socket, Type type,
        Response response, int contentMetaCount, size_t packetSize) NN_NOEXCEPT;

    ssize_t SendContentMetaKey(int socket, const ContentMetaKey& metaKey) NN_NOEXCEPT;

    ssize_t SendSuspend(int socket) NN_NOEXCEPT;

    ssize_t SendResume(int socket) NN_NOEXCEPT;

    ssize_t SendEnd(int socket) NN_NOEXCEPT;

    ssize_t SendEndWithProgress(int socket, const AdvertiseData& advertiseData) NN_NOEXCEPT;

}}} // end of namespace nn::lcs
