﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_NetworkInfo.h>
#include <nn/lcs/detail/lcs_Util.h>

namespace nn { namespace lcs { namespace detail
{
    const size_t EthernetFrameSize = 1518;

    const size_t EthernetHeaderSize = 18;

    const size_t Ipv4HeaderSize = 20;

    const size_t UdpHeaderSize = 8;

    const size_t TcpHeaderSize = 20;

    const size_t UdpDataSizeMax =
        EthernetFrameSize - EthernetHeaderSize - Ipv4HeaderSize - UdpHeaderSize;

    const size_t TcpDataSizeMax =
        EthernetFrameSize - EthernetHeaderSize - Ipv4HeaderSize - TcpHeaderSize;

    const int  ProtocolMajorVersion = 0x1;

    const int  ProtocolMinorVersion = 0x0;

    const size_t SystemDeliveryInfoSize = sizeof(SystemDeliveryInfo);

    const size_t ApplicationDetailInfoSize = sizeof(ApplicationDetailInfo);

    const size_t ApplicationDeliveryInfoSize = sizeof(ApplicationDeliveryInfo);

    const size_t ContentMetaKeySize = sizeof(ContentMetaKey);

    enum Type
    {
        Type_None,
        Type_ApplicationControlDataSizeReq = 0x01,
        Type_ApplicationControlDataSizeRes,
        Type_ApplicationControlDataReq,
        Type_ApplicationControlDataRes,
        Type_Join,
        Type_Leave,
        Type_Accept,
        Type_Reject,
        Type_SessionInfo,
        Type_StartContentsSare,
        Type_Migration,
        Type_ShareSystemClear,         // SystemShareClearPacket
        Type_ShareSystemClearRes,      // SystemShareResPacket
        Type_ShareSystemSendReq,       // SystemShareInfoPacket
        Type_ShareSystemSendRes,       // SystemShareResPacket
        Type_ShareSystemRecvReq,       // SystemShareInfoPacket
        Type_ShareSystemRecvRes,       // SystemShareResPacket
        Type_ShareContentClear,        // ContentShareClearPacket
        Type_ShareContentClearRes,     // ContentShareResPacket
        Type_ShareContentSendReq,      // ContentShareInfoPacket
        Type_ShareContentSendRes,      // ContentShareResPacket
        Type_ShareContentRecvReq,      // ContentShareInfoPacket
        Type_ShareContentRecvRes,      // ContentShareResPacket
        Type_Update,
        Type_Suspend,
        Type_Resume,
        Type_Rejoin,
        Type_EndContentShare,
    };

    enum Response
    {
        Response_Suspend,
        Response_Reject,
        Response_Accept,
    };


    struct CommonHeader
    {
        uint8_t         version;
        uint8_t         type;
        uint16_t        _reserved;
        uint32_t        length;
    };

    struct AppInfoPacket
    {
        uint8_t         appDeliveryInfoCount;
        uint8_t         _reserve1;
        uint16_t        _reserve2;
        uint32_t        _reserve3;
        uint8_t         detailInfo[ApplicationDetailInfoSize];
        // appDeliveryInfoCount * AppDeliveryInfoPacket
    };

    struct AppDeliveryInfoPacket
    {
        uint8_t         deliveryInfo[ApplicationDeliveryInfoSize];
    };

    struct NodeInfoPacket
    {
        uint32_t        index;
        char            _reserved[7];
        uint8_t         userName[UserNameBytesMax + 1];
    };

    struct ContentMetaKeyPacket
    {
        uint8_t         contentMetaKey[ContentMetaKeySize];
    };

    struct AppControlDataReqPacket
    {
        CommonHeader    header;
        uint32_t        appUpperId;
        uint32_t        appLowerId;
    };

    struct AppControlDataResPacket
    {
        CommonHeader    header;
        uint32_t        appUpperId;
        uint32_t        appLowerId;
        uint32_t        dataSize;
    };

    struct NodeDetailInfoPacket
    {
        CommonHeader    header;
        uint8_t         lcsVersion;
        uint8_t         appCount;
        uint8_t         downloadedContentCount;
        uint8_t         userName[UserNameBytesMax + 1];
        uint32_t        _reserve;
        uint8_t         sysInfo[SystemDeliveryInfoSize];
        // appCount * AppInfoPacket
    };

    struct LeavePacket
    {
        CommonHeader    header;
        uint8_t         leaveReason;
        uint8_t         _reserved1;
        uint16_t        _reserved2;
    };

    struct AcceptPacket
    {
        CommonHeader    header;
        uint32_t        index;
    };

    struct RejectPacket
    {
        CommonHeader    header;
        uint8_t         rejectReason;
        uint8_t         _reserved1;
        uint16_t        _reserved2;
    };

    struct SessionInfoPacket
    {
        CommonHeader    header;
        uint8_t         appCount;
        uint8_t         nodeCount;
        uint16_t        _reserve2;
        uint32_t        _reserve3;
        // appCount * AppInfoPacket
        // nodeCount * NodeInfoPacket
    };

    struct StartContentsSarePacket
    {
        CommonHeader    header;
    };

    struct MigrationPacket
    {
        CommonHeader    header;
        uint8_t         migrationInfo[MigrationInfoSize];
    };

    struct SystemShareClearPacket
    {
        CommonHeader    header;
        uint8_t         systemUpdateReason;
        uint8_t         _reserve1;
        uint16_t        _reserve2;
    };

    struct SystemShareInfoPacket
    {
        CommonHeader    header;
        uint8_t         role;
        uint8_t         connectTimeout;
        uint8_t         channel;
        uint8_t         _reserve1;
        uint32_t        address;
        uint32_t        nodeIndex;
        uint32_t        _reserve2;
        uint8_t         sysInfo[SystemDeliveryInfoSize];
    };

    struct SystemShareResPacket
    {
        CommonHeader    header;
        uint8_t         response;
        uint8_t         _reserve1;
        uint16_t        _reserve2;
        uint8_t         sysInfo[SystemDeliveryInfoSize];
    };

    struct ContentShareClearPacket
    {
        CommonHeader    header;
        uint8_t         contentsFlag;
        uint8_t         _reserve1;
        uint16_t        _reserve2;
        uint32_t        appUpperId;
        uint32_t        appLowerId;
    };

    struct ContentShareInfoPacket
    {
        CommonHeader    header;
        uint8_t         role;
        uint8_t         contentsFlag;
        uint8_t         connectTimeout;
        uint8_t         channel;
        uint8_t         contentMetaKeyCount;
        uint8_t         _reserve1;
        uint16_t        _reserve2;
        uint32_t        address;
        uint32_t        nodeIndex;
        uint32_t        appUpperId;
        uint32_t        appLowerId;
        // ContentMetaKeyPacket
    };

    struct ContentShareResPacket
    {
        CommonHeader    header;
        uint8_t         response;
        uint8_t         contentMetaKeyCount;
        uint16_t        _reserve1;
        uint32_t        _reserve2;
        // ContentMetaKeyPacket
    };

    struct SuspendPacket
    {
        CommonHeader    header;
    };

    struct ResumePacket
    {
        CommonHeader    header;
    };

    struct EndContentsSarePacket
    {
        CommonHeader    header;
    };

    struct EndContentsShareWithProgressPacket
    {
        CommonHeader    header;
        uint8_t         progress[sizeof(AdvertiseNodeProgress) * NodeCountMax];
    };

}}} // end of namespace nn::lcs
