﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/lcs_Types.h>

namespace nn { namespace lcs { namespace detail
{
    enum SessionAttribute
    {
        SessionAttribute_Close,
        SessionAttribute_Open,
        SessionAttribute_Limited,
    };

    struct AdvertiseNodeProgress
    {
        uint8_t contentCount;
        uint8_t downloadedContentCount;
        uint16_t _reserved;
        uint32_t id;
    };
    NN_STATIC_ASSERT(sizeof(AdvertiseNodeProgress) == 8);

    struct AdvertiseContentInfo
    {
        Bit8 contentsFlag;
        char _reserved[3];
        Bit32 attributeFlag;
        Bit64 id;
        uint64_t requiredSize;
        char displayVersion[DisplayVersionSizeMax];
    };
    NN_STATIC_ASSERT(sizeof(AdvertiseContentInfo) == 40);

    struct AdvertiseData
    {
        uint8_t lcsVersion;
        uint8_t sessionAttribute;
        uint8_t nodeCount;
        uint8_t nodeCountMax;
        uint8_t contentCount;
        bool isContentShareSucceeded;
        uint8_t sessionState;
        char _reserved[16];
        char hostUserName[UserNameBytesMax + 1];
        AdvertiseNodeProgress progress[NodeCountMax];
        AdvertiseContentInfo contents[SharableContentsCountMax];
    };
    NN_STATIC_ASSERT(sizeof(AdvertiseData) == 256);


}}} // end of namespace nn::lcs
