﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

namespace {

const KeyCodeMapStorage KeyCodeMapEnglishUsInternational =
{ { { 0x03000001 } }, 5, 100, 3, {}, {
    AltGrLetter, 0x0061, 0x0041, 0x00E1, 0x00C1, // A Á
    BasicLetter, 0x0062, 0x0042, 0x0000, 0x0000, // B
    BasicLetter, 0x0063, 0x0043, 0x00A9, 0x00A2, // C © ¢
    AltGrLetter, 0x0064, 0x0044, 0x00F0, 0x00D0, // D Ð
    AltGrLetter, 0x0065, 0x0045, 0x00E9, 0x00C9, // E É
    BasicLetter, 0x0066, 0x0046, 0x0000, 0x0000, // F
    BasicLetter, 0x0067, 0x0047, 0x0000, 0x0000, // G
    BasicLetter, 0x0068, 0x0048, 0x0000, 0x0000, // H
    AltGrLetter, 0x0069, 0x0049, 0x00ED, 0x00CD, // I Í
    BasicLetter, 0x006A, 0x004A, 0x0000, 0x0000, // J
    BasicLetter, 0x006B, 0x004B, 0x0000, 0x0000, // K
    AltGrLetter, 0x006C, 0x004C, 0x00F8, 0x00D8, // L Ø
    BasicLetter, 0x006D, 0x004D, 0x00B5, 0x0000, // M µ
    AltGrLetter, 0x006E, 0x004E, 0x00F1, 0x00D1, // N Ñ
    AltGrLetter, 0x006F, 0x004F, 0x00F3, 0x00D3, // O Ó
    AltGrLetter, 0x0070, 0x0050, 0x00F6, 0x00D6, // P Ö
    AltGrLetter, 0x0071, 0x0051, 0x00E4, 0x00C4, // Q Ä
    BasicLetter, 0x0072, 0x0052, 0x00AE, 0x0000, // R ®
    BasicLetter, 0x0073, 0x0053, 0x00DF, 0x00A7, // S ß §
    AltGrLetter, 0x0074, 0x0054, 0x00FE, 0x00DE, // T þ
    AltGrLetter, 0x0075, 0x0055, 0x00FA, 0x00DA, // U Ú
    BasicLetter, 0x0076, 0x0056, 0x0000, 0x0000, // V
    AltGrLetter, 0x0077, 0x0057, 0x00E5, 0x00C5, // W Å
    BasicLetter, 0x0078, 0x0058, 0x0000, 0x0000, // X
    AltGrLetter, 0x0079, 0x0059, 0x00FC, 0x00DC, // Y Ü
    AltGrLetter, 0x007A, 0x005A, 0x00E6, 0x00C6, // Z Æ
    BasicSymbol, 0x0031, 0x0021, 0x00A1, 0x00B9, // 1 ! ¡ ¹
    BasicSymbol, 0x0032, 0x0040, 0x00B2, 0x0000, // 2 @ ²
    BasicSymbol, 0x0033, 0x0023, 0x00B3, 0x0000, // 3 # ³
    BasicSymbol, 0x0034, 0x0024, 0x00A4, 0x00A3, // 4 $ ¤ £
    BasicSymbol, 0x0035, 0x0025, 0x20AC, 0x0000, // 5 % €
    BasicSymbol, 0x0036, 0x0302, 0x00BC, 0x0000, // 6 ^ ¼
    BasicSymbol, 0x0037, 0x0026, 0x00BD, 0x0000, // 7 & ½
    BasicSymbol, 0x0038, 0x002A, 0x00BE, 0x0000, // 8 * ¾
    BasicSymbol, 0x0039, 0x0028, 0x2018, 0x0000, // 9 ( ‘
    BasicSymbol, 0x0030, 0x0029, 0x2019, 0x0000, // 0 ) ’
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Enter
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Escape
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Backspace
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Tab
    BasicSymbol, 0x0020, 0x0020, 0x0020, 0x0020, // Space
    BasicSymbol, 0x002D, 0x005F, 0x00A5, 0x0000, // - _ ¥
    BasicSymbol, 0x003D, 0x002B, 0x00D7, 0x00F7, // = + × ÷
    BasicSymbol, 0x005B, 0x007B, 0x00AB, 0x0000, // [ { «
    BasicSymbol, 0x005D, 0x007D, 0x00BB, 0x0000, // ] } »
    BasicSymbol, 0x005C, 0x007C, 0x00AC, 0x00A6, // / | ¬ ¦
    BasicSymbol, 0x005C, 0x007C, 0x00AC, 0x00A6, // / | ¬ ¦
    BasicSymbol, 0x003B, 0x003A, 0x00B6, 0x00B0, // ; : ¶ °
    BasicSymbol, 0x030D, 0x030E, 0x00B4, 0x00A8, // ' " ´ ¨
    BasicSymbol, 0x0300, 0x0303, 0x0000, 0x0000, // ` ~
    AltGrSymbol, 0x002C, 0x003C, 0x00E7, 0x00C7, // , < Ç
    BasicSymbol, 0x002E, 0x003E, 0x0000, 0x0000, // . >
    BasicSymbol, 0x002F, 0x003F, 0x00BF, 0x0000, // / ? ¿
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Caps Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F1
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F2
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F3
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F4
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F5
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F6
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F7
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F8
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F9
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F10
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F11
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F12
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // PrintScreen
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Scroll Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Pause
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Insert
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Home
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // PageUp
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Delete
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // End
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // PageDown
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // →
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // ←
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // ↓
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // ↑
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Num Lock
    BasicSymbol, 0x002F, 0x002F, 0x002F, 0x002F, // Keypad /
    BasicSymbol, 0x002A, 0x002A, 0x002A, 0x002A, // Keypad *
    BasicSymbol, 0x002D, 0x002D, 0x002D, 0x002D, // Keypad -
    BasicSymbol, 0x002B, 0x002B, 0x002B, 0x002B, // Keypad +
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Keypad Enter
    BasicKeypad, 0x0000, 0x0031, 0x0000, 0x0031, // Keypad 1
    BasicKeypad, 0x0000, 0x0032, 0x0000, 0x0032, // Keypad 2
    BasicKeypad, 0x0000, 0x0033, 0x0000, 0x0033, // Keypad 3
    BasicKeypad, 0x0000, 0x0034, 0x0000, 0x0034, // Keypad 4
    BasicKeypad, 0x0020, 0x0035, 0x0020, 0x0035, // Keypad 5
    BasicKeypad, 0x0000, 0x0036, 0x0000, 0x0036, // Keypad 6
    BasicKeypad, 0x0000, 0x0037, 0x0000, 0x0037, // Keypad 7
    BasicKeypad, 0x0000, 0x0038, 0x0000, 0x0038, // Keypad 8
    BasicKeypad, 0x0000, 0x0039, 0x0000, 0x0039, // Keypad 9
    BasicKeypad, 0x0000, 0x0030, 0x0000, 0x0030, // Keypad 0
    BasicKeypad, 0x0000, 0x002E, 0x0000, 0x002E, // Keypad .
    BasicSymbol, 0x005C, 0x007C, 0x0000, 0x0000, // \ |
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Application
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Power
    BasicSymbol, 0x003D, 0x003D, 0x003D, 0x003D, // Keypad =
} };

} // namespace

}}} // namespace nn::kpr::detail
