﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/irsensor/irsensor_ClusteringProcessorTypes.h>
#include <nn/irsensor/irsensor_MomentProcessorTypes.h>
#include <nn/irsensor/irsensor_ImageTransferProcessorTypes.h>
#include <nn/irsensor/irsensor_PointingProcessorTypesPrivate.h>
#include <nn/irsensor/irsensor_TeraPluginProcessorTypesPrivate.h>
#include <nn/irsensor/irsensor_IrCameraTypes.h>
#include <nn/irsensor/irsensor_PackedTypes.h>

namespace nn { namespace irsensor {

class IIrSensorDriver
{
public:
    virtual ~IIrSensorDriver() NN_NOEXCEPT { /* 何もしない */ }

    virtual ::nn::Result CheckVersion(
        const ::nn::irsensor::PackedMcuVersion& requiredVersion,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result RequestVersion() NN_NOEXCEPT = 0;

    virtual ::nn::Result StopImageProcessor() NN_NOEXCEPT = 0;

    virtual ::nn::Result SuspendImageProcessor() NN_NOEXCEPT = 0;

    virtual ::nn::Result StopSampling() NN_NOEXCEPT = 0;

    virtual ::nn::Result RunImageProcessor(
        const PackedMomentProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result RunImageProcessor(
        const PackedClusteringProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result RunImageProcessor(
        const PackedImageTransferProcessorExConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel,
        void* buffer) NN_NOEXCEPT = 0;

    virtual ::nn::Result RunImageProcessor(
        const PackedPointingProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result RunImageProcessor(
        const PackedTeraPluginProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result RunImageProcessor(
        const PackedIrLedProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result ResumeImageProcessor(
        const PackedMomentProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result ResumeImageProcessor(
        const PackedClusteringProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result ResumeImageProcessor(
        const PackedImageTransferProcessorExConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel,
        void* buffer) NN_NOEXCEPT = 0;

    virtual ::nn::Result ResumeImageProcessor(
        const PackedPointingProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result ResumeImageProcessor(
        const PackedTeraPluginProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result ResumeImageProcessor(
        const PackedIrLedProcessorConfig& config,
        const ::nn::irsensor::PackedFunctionLevel& functionLevel
        ) NN_NOEXCEPT = 0;

    virtual ::nn::Result GetImageProcessorStates(
        MomentProcessorState* pOutStates,
        int* pOutCount, int countMax) NN_NOEXCEPT = 0;

    virtual ::nn::Result GetImageProcessorStates(
        ClusteringProcessorState* pOutStates,
        int* pOutCount, int countMax) NN_NOEXCEPT = 0;

    virtual ::nn::Result GetImageProcessorState(
        ImageTransferProcessorState* pOutState,
        void* pOutImage) NN_NOEXCEPT = 0;

    virtual ::nn::Result GetImageProcessorStates(
        PointingProcessorMarkerState* pOutStates,
        int* pOutCount, int countMax) NN_NOEXCEPT = 0;

    virtual ::nn::Result GetImageProcessorStates(
        TeraPluginProcessorState* pOutStates,
        int* pOutCount, int countMax) NN_NOEXCEPT = 0;

    virtual ::nn::Result SetIrCameraStatus(
        IrCameraStatus status) NN_NOEXCEPT = 0;

    virtual ::nn::Result SetXcdDeviceHandle(
        ::nn::xcd::DeviceHandle handle) NN_NOEXCEPT = 0;

    virtual ::nn::Result SetLatestTransferMemoryAddress(
        void* pLatestTransferMemoryAddress) NN_NOEXCEPT = 0;
};

}} // namespace nn::irsensor
