﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/irsensor/irsensor_TeraPluginProcessorTypesPrivate.h>


namespace nn { namespace irsensor {

const int IrHandAnalysisHistoryCapacity = 64;  //!< maximum number of samples in full frame shape history

const int HandAnalysisPrefixSize = 2;
const uint32_t HandAnalysisPrefixSilouette         = 0x2;
const uint32_t HandAnalysisPrefixImage             = 0x1;

/**
* @brief Additional data structure when objects (fingers) convers whole irsensor
*/
struct HandAnalysisFullFrameShape
{
    struct IntensitySample
    {
        int relativeSamplingNumber;                      //!< sampling number relative to the next newest sample. Should be 0 for intensityHistory[0]. The sampling number of intensityHistory[i] can be computed as sampling number of intensityHistory[i-1] - relativeSamplingNumber for i >= 1 and intensitySamplingNumber for i = 0.
        int intensity;                                   //!< intensity value
    };

    bool isFullFrame;                                                //!< boolean flag if finger objects (fingers) covers entire irsensor
    int intensitySamplingPeriod;                                     //!< time between two consecutive samples, in microseconds
    int intensitySamplingNumber;                                     //!< sampling number of the newest sample
    int captureId;                                                   //!< id of the parent shape for holes or merged shapes (if no parent, it is same as id)
    int intensityHistoryCount;                                       //!< how many intensity data are stored
    IntensitySample intensityHistory[IrHandAnalysisHistoryCapacity]; //!< intensity data list
};

/**
* @brief Structure for addtional information of shape
*/
struct HandAnalysisSilhouetteStateWithFullFrameShape
{
    HandAnalysisSilhouetteState silhouetteState;                   //!< handanalysis result
    HandAnalysisFullFrameShape  fullframeState;                    //!< extra data for handanalysis mode
};

}} // namespace nn::irsensor
