﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Joy-Con に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace hid { namespace system {

//! @name Npad 本体機能向け Joy-Con 関連 API
//! @{

/**
 * @brief       Bluetooth がオフの間に Joy-Con が本体から取り外されたときに通知を受け取るためのイベントオブジェクトを登録します。
 *
 * @details     Bluetooth がオフの間に Joy-Con が本体から取り外されたことに対する通知をイベントオブジェクトにバインドします。
 *              同時に複数のイベントオブジェクトに対してバインドすることはできません。
 *
 * @param[in]   pEvent                  イベントオブジェクトを指すポインタ
 * @param[in]   clearMode               イベントオブジェクトのクリアモード
 *
 * @pre
 *              - pEvent != nullptr
 *              - *pEvent は未初期化状態
 * @post
 *              - *pEvent は初期化状態
 *              - *pEvent はシグナル状態
 */
void BindJoyDetachOnBluetoothOffEvent(::nn::os::SystemEventType* pEvent,
                                     ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

//! @}

}}} // namespace nn::hid::system
