﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       DebugPad のエミュレーション設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_DebugPad.h>

namespace nn { namespace hid {

/**
 * @brief       DebugPad に対する汎用ゲームパッドの割り当てを取得します。
 *
 * @details     ::nn::settings::GetDebugPadGenericPadMap() の内部実装です。
 *
 * @param[out]  outValue                    DebugPad に対する汎用ゲームパッドの割り当てを読み出すバッファ
 *
 * @return      処理の結果が返ります。
 * @retval      ResultSuccess                           成功しました。
 * @retval      ResultDebugPadNullGenericPadMapBuffer   DebugPad に対する汎用ゲームパッドの割り当ての読み出し先が NULL 値です。
 *
 * @pre
 *              - outValue != nullptr
 */
::nn::Result GetDebugPadGenericPadMap(
    ::nn::settings::DebugPadGenericPadMap* outValue) NN_NOEXCEPT;

/**
 * @brief       DebugPad に対する汎用ゲームパッドの割り当てを設定します。
 *
 * @details     ::nn::settings::SetDebugPadGenericPadMap() の内部実装です。
 *
 * @param[in]   value                       DebugPad に対する汎用ゲームパッドの割り当て
 *
 * @return      処理の結果が返ります。
 * @retval      ResultSuccess                           成功しました。
 */
::nn::Result SetDebugPadGenericPadMap(
    const ::nn::settings::DebugPadGenericPadMap& value) NN_NOEXCEPT;

/**
 * @brief       DebugPad に対する汎用ゲームパッドの割り当てをリセットします。
 *
 * @details     ::nn::settings::ResetDebugPadGenericPadMap() の内部実装です。
 *
 * @return      処理の結果が返ります。
 * @retval      ResultSuccess                           成功しました。
 */
::nn::Result ResetDebugPadGenericPadMap() NN_NOEXCEPT;

/**
 * @brief       DebugPad に対するキーボードの割り当てを取得します。
 *
 * @details     ::nn::settings::GetDebugPadKeyboardMap() の内部実装です。
 *
 * @param[out]  outValue                    DebugPad に対するキーボードの割り当てを読み出すバッファ
 *
 * @return      処理の結果が返ります。
 * @retval      ResultSuccess                           成功しました。
 * @retval      ResultDebugPadNullKeyboardMapBuffer     DebugPad に対するキーボードの割り当ての読み出し先が NULL 値です。
 *
 * @pre
 *              - outValue != nullptr
 */
::nn::Result GetDebugPadKeyboardMap(
    ::nn::settings::DebugPadKeyboardMap* outValue) NN_NOEXCEPT;

/**
 * @brief       DebugPad に対するキーボードの割り当てを設定します。
 *
 * @details     ::nn::settings::SetDebugPadKeyboardMap() の内部実装です。
 *
 * @param[in]   value                       DebugPad に対するキーボードの割り当て
 *
 * @return      処理の結果が返ります。
 * @retval      ResultSuccess                           成功しました。
 */
::nn::Result SetDebugPadKeyboardMap(
    const ::nn::settings::DebugPadKeyboardMap& value) NN_NOEXCEPT;

/**
 * @brief       DebugPad に対するキーボードの割り当てをリセットします。
 *
 * @details     ::nn::settings::ResetDebugPadKeyboardMap() の内部実装です。
 *
 * @return      処理の結果が返ります。
 * @retval      ResultSuccess                           成功しました。
 */
::nn::Result ResetDebugPadKeyboardMap() NN_NOEXCEPT;

}} // namespace nn::hid
