﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       本体 6 軸センサーに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid/hid_SixAxisSensor.h>

namespace nn { namespace hid {

const int ConsoleSixAxisSensorStateCountMax = 32;      //!< 内部的に保持される SixAxisSensorState の最大数

/**
 * @brief       本体 6 軸センサーのハンドルを表す構造体です。
 */
struct ConsoleSixAxisSensorHandle
{
    int32_t _storage;
};

//! @name 本体 6 軸センサー関連 API
//! @{

/**
 * @brief       ConsoleSixAxisSensor を初期化します。
 *
 * @deprecated  InitializeConsoleSixAxisSensor は廃止されました。InitializeSevenSixAxisSensor を利用してください。
 */
void InitializeConsoleSixAxisSensor() NN_NOEXCEPT;

/**
 * @brief       本体 6 軸センサーを操作するためのハンドルを取得します。
 *
 * @details     本体 6 軸センサーを操作するためのハンドルを取得します。
 *
 * @deprecated  GetSixAxisSensorHandle は廃止されました。
 *
 * @param[out]  pOutValue       6軸センサーのハンドルの格納先
 *
 * @pre
 *              InitializeConsoleSixAxisSensor() の呼び出しが完了している
 */
void GetSixAxisSensorHandle(ConsoleSixAxisSensorHandle* pOutValue) NN_NOEXCEPT;

/**
 * @brief       SixAxisSensor のサンプリングを開始します。
 *
 * @details     指定の handle と対応する 6 軸センサーのサンプリングを開始します。
 *              本関数が呼び出された際にコントローラの基準姿勢が設定されます。
 *              基準姿勢の Z 軸は重力方向、X/Y軸は初期化時点でのコントローラの姿勢と
 *              基準姿勢との差異が少なくなるような軸が指定されます。
 *
 * @deprecated  StartSixAxisSensor は廃止されました。 StartSevenSixAxisSensor を利用してください。
 *
 * @param[in]   handle                      6軸センサーのハンドル
 *
 * @pre
 *              InitializeConsoleSixAxisSensor() の呼び出しが完了している
 */
void StartSixAxisSensor(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

/**
 * @brief       SixAxisSensor のサンプリングを停止します。
 *
 * @details     指定の handle と対応する 6 軸センサーのサンプリングを停止します。
 *
 * @deprecated  StopSixAxisSensor は廃止されました。 StopSevenSixAxisSensor を利用してください。
 *
 * @param[in]   handle                      6軸センサーのハンドル
 *
 * @pre
 *              InitializeConsoleSixAxisSensor() の呼び出しが完了している
 */
void StopSixAxisSensor(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

//! @}

}} // namespace nn::hid
