﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Mouse のデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_Mouse.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       Mouse の自動操作状態を表す構造体です。
 */
struct MouseAutoPilotState
{
    int32_t x;                      //!< カーソルの x 座標
    int32_t y;                      //!< カーソルの y 座標
    int32_t deltaX;                 //!< カーソルの x 座標の移動差分です。
    int32_t deltaY;                 //!< カーソルの y 座標の移動差分です。
    int32_t wheelDelta;             //!< ホイールの回転差分
    MouseButtonSet buttons;         //!< ボタンの状態
    MouseAttributeSet attributes;   //!< Mouse の入力状態の属性
};

/**
 * @brief       Mouse をファイナライズします。
 *
 * @details     事前に nn::hid::InitializeMouse() を呼び出した回数と同じだけ
 *              呼びだされた際に Mouse の初期化状態を解除します。
 *
 * @pre
 *              - Mouse が初期化状態にある
 */
void FinalizeMouse() NN_NOEXCEPT;

/**
 * @brief       Mouse に自動操作状態を設定します。
 *
 * @param[in]   value                       Mouse の自動操作状態
 *
 * @pre
 *              - Mouse が初期化状態にある
 */
void SetMouseAutoPilotState(const MouseAutoPilotState& value) NN_NOEXCEPT;

/**
 * @brief       Mouse の自動操作状態を解除します。
 *
 * @pre
 *              - Mouse が初期化状態にある
 */
void UnsetMouseAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
