﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       DebugPad のデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_AnalogStickState.h>
#include <nn/hid/hid_DebugPad.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       DebugPad の自動操作状態を表す構造体です。
 */
struct DebugPadAutoPilotState
{
    DebugPadAttributeSet attributes;    //!< DebugPad の入力状態の属性です。
    DebugPadButtonSet buttons;          //!< DebugPad のデジタルボタンの状態です。
    AnalogStickState analogStickL;      //!< DebugPad の左アナログスティックの状態です。
    AnalogStickState analogStickR;      //!< DebugPad の右アナログスティックの状態です。
};

/**
 * @brief       DebugPad をファイナライズします。
 *
 * @details     事前に nn::hid::InitializeDebugPad() を呼び出した回数と同じだけ
 *              呼びだされた際に DebugPad が初期化状態を解除します。
 *
 * @pre
 *              - DebugPad が初期化状態にある
 */
void FinalizeDebugPad() NN_NOEXCEPT;

/**
 * @brief       DebugPad に自動操作状態を設定します。
 *
 * @param[in]   value                       DebugPad の自動操作状態
 *
 * @pre
 *              - DebugPad が初期化状態にある
 */
void SetDebugPadAutoPilotState(const DebugPadAutoPilotState& value) NN_NOEXCEPT;

/**
 * @brief       DebugPad の自動操作状態を解除します。
 *
 * @pre
 *              - DebugPad が初期化状態にある
 */
void UnsetDebugPadAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
