﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       撮影ボタンのデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_CaptureButton.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       撮影ボタンの自動操作状態を表す構造体です。
 */
struct CaptureButtonAutoPilotState
{
    ::nn::hid::system::CaptureButtonSet buttons;    //!< 撮影ボタンのデジタルボタンの状態です。
};

/**
 * @brief       撮影ボタンをファイナライズします。
 *
 * @details     事前に nn::hid::system::InitializeCaptureButton() を呼び出した
 *              回数と同じだけ呼びだされた際にホームボタンが初期化状態を
 *              解除します。
 *
 * @pre
 *              - 撮影ボタンが初期化状態にある
 */
void FinalizeCaptureButton() NN_NOEXCEPT;

/**
 * @brief       撮影ボタンに自動操作状態を設定します。
 *
 * @param[in]   value                       撮影ボタンの自動操作状態
 *
 * @pre
 *              - 撮影ボタンが初期化状態にある
 */
void SetCaptureButtonAutoPilotState(const CaptureButtonAutoPilotState& value
                                    ) NN_NOEXCEPT;

/**
 * @brief       撮影ボタンの自動操作状態を解除します。
 *
 * @pre
 *              - 撮影ボタンが初期化状態にある
 */
void UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
