﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_File.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/capsrv/movie/capsrv_MovieMetaDataBuilder.h>

#include <utility>

namespace nn { namespace grcsrv {

class DataWriter
{
protected:

    ~DataWriter() = default;

public:

    virtual Result WriteData(fs::FileHandle handle) NN_NOEXCEPT = 0;

};

template <typename F>
class FunctorDataWriter final
    : public DataWriter
{
private:
    F m_F;
    virtual Result WriteData(fs::FileHandle handle) NN_NOEXCEPT NN_OVERRIDE
    {
        return m_F(handle);
    }
public:
    explicit FunctorDataWriter(F&& f) NN_NOEXCEPT
        : m_F(std::forward<F>(f))
    {
    }
};

template <typename F>
inline FunctorDataWriter<F> MakeFunctorDataWriter(F&& f) NN_NOEXCEPT
{
    return FunctorDataWriter<F>(std::forward<F>(f));
}

class MovieFileWriter
{
protected:

    ~MovieFileWriter() = default;

public:

    // pMetaBuilder には SetMovieDataSize() 以外を呼んでから渡す
    virtual Result Write(const capsrv::AlbumFileId& albumFileId, DataWriter* pDataWriter, capsrv::movie::MovieMetaDataBuilder* pMetaBuilder) NN_NOEXCEPT = 0;

};

}}
