﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/grc/grc_CommonTypes.h>
#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace grc {

Result InitializeByHipc() NN_NOEXCEPT;
void FinalizeByHipc() NN_NOEXCEPT;
Result CreateContinuousRecorder(sf::SharedPointer<grcsrv::IContinuousRecorder>* pOut, sf::NativeHandle workMemoryHandle, uint64_t workMemorySize, const ContinuousRecordingParameter& parameter) NN_NOEXCEPT;
Result CreateGameMovieTrimmer(sf::SharedPointer<grcsrv::IGameMovieTrimmer>* pOut, sf::NativeHandle workMemoryHandle, uint64_t workMemorySize) NN_NOEXCEPT;
Result CreateOffscreenRecorder(sf::SharedPointer<grcsrv::IOffscreenRecorder>* pOut, sf::NativeHandle workMemoryHandle, uint64_t workMemorySize) NN_NOEXCEPT;
Result CreateMovieMakerForApplication(sf::SharedPointer<grcsrv::IMovieMaker>* pOut, applet::AppletResourceUserId aruid, ncm::ApplicationId applicationId) NN_NOEXCEPT;

// テスト用。
// OffscreenRecorder の所定の箇所でエラーを発生させる。
// 0 (Invalid) を指定した場合、この機能は無効化される。初期値は 0。
void SetOffscreenRecorderCheckPointForTesting(uint64_t value) NN_NOEXCEPT;

}}
