﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "gfxTool_ApiCommon.h"

enum
{
    nngfxToolShaderCompilerLowLevelApiType_Gx = 1 //!< GX です。
};

enum
{
    nngfxToolShaderCompilerPlatform_Cafe = 1 //!< Cafe です。
};

enum
{
    nngfxToolShaderCompilerOptionType_Gx = 2 //!< GX のオプションです。
};

enum
{
    nngfxToolShaderCompilerOptionOutputType_ProgramGx = 1 //!< GX のプログラム単位のオプションです。
};

/**
* @brief GX 特有のコンパイルオプションです。
*/
struct nngfxToolShaderCompilerCompileOptionGx
{
    uint64_t optimizeFlags; //!< 最適化フラグです。詳細は CafeSDK を参照してください。

    const char* pSparkOutputDir; //!< Spark のシンボル情報の出力ディレクトリへのポインタです。

    char reserved[ 64 ]; //!< 予約領域です。
};
