﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>

#include <nn/gfxTool/gfxTool_Error.h>

namespace nn {
namespace gfxTool {

class DllBase
{
public:
    DllBase()
        : m_hDll()
    {
    }

    virtual ~DllBase()
    {
        Finalize();
    }

    virtual bool Initialize( const char* pDllPath ) NN_NOEXCEPT;

    virtual void Finalize() NN_NOEXCEPT;

    virtual bool IsInitialized() const
    {
        return m_hDll != nullptr;
    }

protected:
    template< typename TFunc >
    TFunc GetFunction( const char* pFunctionName )
    {
        return static_cast< TFunc >( GetFunctionImpl( pFunctionName ) );
    }

    template< typename TFunc >
    TFunc GetRequiredFunction( const char* pFunctionName )
    {
        TFunc ret = GetFunction< TFunc >( pFunctionName );
        if( ret == nullptr )
        {
            NN_GFXTOOL_THROW_MSG( nngfxToolResultCode_DllFunctionNotFound,
                "Failed to load %s.", pFunctionName );
        }
        return ret;
    }

private:
    void* GetFunctionImpl( const char* pFunctionName ) NN_NOEXCEPT;

protected:
    void* m_hDll;
};

}
}
