﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief コマンドバッファのデータに関する API の宣言（GL4 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief コマンドバッファを表す構造体です（GL4 特殊版）
*/
template<>
struct CommandBufferImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized,
        State_Begun,
        State_Callback
    };

    Bit8 state; //!< オブジェクトの状態です。
    Bit8 commandBufferType; //!< コマンドバッファの種類です
    Bit16 queueCapability; //!< 提出先のキューの機能性です
    uint32_t controlMemorySize; //!< コントロールメモリのサイズです
    detail::Ptr< const void > pCommandList; //!< コマンドリストへのポインタです
    detail::Ptr< void > pCommandMemory; //!< コマンドメモリへのポインタです
    detail::Ptr< const void > pHeadControlMemory; //!< コントロールメモリの先頭へのポインタです
    detail::Ptr< void > pControlMemory; //!< コントロールメモリへのポインタです
    detail::Ptr< void () > pOutOfCommandMemoryCallback; // コマンドメモリが不足したときに呼ばれるコールバックへのポインタです
    detail::Ptr< void () > pOutOfControlMemoryCallback; //!< コントロールメモリが不足したときに呼ばれるコールバックへのポインタです

    detail::Ptr< detail::DeviceImpl< ApiVariationGx2 > > pDevice; //!< デバイスへのポインタです
    detail::Ptr< const detail::RootSignatureImpl< ApiVariationGx2 > > pGfxRootSignature; //!< ルートシグネチャへのポインタです

    detail::Ptr< void > userPtr; //!< ユーザデータへのポインタです

    char defaultControlMemory[ 64 ]; //!< デフォルトのコントロールメモリです
};


}
}
