﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/ens_Types.h>

namespace nn { namespace ens { namespace detail {

// internal use only
struct TaskId
{
    uint64_t value;

    friend bool operator==(const TaskId& lhs, const TaskId& rhs) NN_NOEXCEPT
    {
        return lhs.value == rhs.value;
    }

    friend bool operator!=(const TaskId& lhs, const TaskId& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }
};

// internal use only
using CancelObserver = void (*)(const TaskId& taskId);

// internal use only
using DestructObserver = void (*)(const TaskId& taskId);

// internal use only
static const TaskId InvalidTaskId = {0ull};

}}}
