﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>

namespace nn { namespace ens { namespace detail { namespace core { namespace task {

/**
 * @brief   Report の非同期処理実装タスク
 *
 * @details
 */
class TaskReport : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskReport() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskReport() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   pType       通報対象の種別
     * @param[in]   nsaId       ネットワークサービスアカウント ID
     * @param[in]   category    通報カテゴリ
     * @param[in]   pReason     通報理由
     * @param[in]   image       証拠画像
     * @param[in]   contentInfo コンテンツ情報
     *
     * @details
     */
    void SetParameter(const char* pType, nn::account::NetworkServiceAccountId nsaId,
        ReportCategory category, const char* pReason,
        const SendBuffer& image,
        const ReportContentInfo& contentInfo) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    const char* m_pType;
    nn::account::NetworkServiceAccountId m_NsaId;
    //
    ReportCategory m_Category;
    const char* m_pReason;
    //
    SendBuffer m_Image;
    //
    ReportContentInfo m_ContentInfo;

private:
    //
    nn::Result StepReport() NN_NOEXCEPT;
};

}}}}}
