﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>
#include <nn/ens/ens_TypesForAcbaa.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

/**
 * @brief   DeleteMessage の非同期処理実装タスク
 *
 * @details
 */
class TaskDeleteMessage : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskDeleteMessage() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskDeleteMessage() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   pMessageIdList  削除するメッセージの ID リスト
     * @param[in]   count           pMessageIdList の要素数
     * @param[in]   pReason         削除理由
     *
     * @details
     */
    void SetParameter(const MessageId* pMessageIdList, int count, const char* pReason) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    const MessageId* m_pMessageIdList;
    int m_Count;
    //
    const char* m_pReason;

private:
    //
    nn::Result StepDelete() NN_NOEXCEPT;
};

}}}}}
