﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrv_MovieConfig.h"
#include "capsrv_CachedMovieStream.h"

namespace nn{ namespace capsrv{ namespace movie{

    struct MovieReaderCacheStrategy
    {
    public:
        static const int EntryCountMax = MovieReaderCacheChunkCountMax;
        static const int64_t InvalidChunkIndex = CachedMovieStream::InvalidChunkIndex;

    private:
        struct Entry
        {
        public:
            void Reset() NN_NOEXCEPT;
        public:
            int64_t chunkIndex;
            uint64_t date;
        };

    public:
        static void NotifyFetched(int64_t chunkIndex, void* userData) NN_NOEXCEPT;
        static void NotifyInvalidated(int64_t chunkIndex, void* userData) NN_NOEXCEPT;
        static void NotifyRead(int64_t chunkIndex, int64_t offset, int64_t size, void* userData) NN_NOEXCEPT;
        static void NotifyWritten(int64_t chunkIndex, int64_t offset, int64_t size, void* userData) NN_NOEXCEPT;
        static int64_t QueryChunkIndexToInvalidate(void* userData) NN_NOEXCEPT;

        // @pre cacheChunkCount > 0
        // @pre cacheChunkCount <= CacheChunkCountMax
        void Initialize(int64_t cacheChunkCount) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::capsrv::movie::MovieStreamCacheStrategy GetStrategy() NN_NOEXCEPT;

    private:
        Entry* FindEntry(int64_t chunkIndex) NN_NOEXCEPT;

    public:
        int64_t m_EntryCount;
        Entry m_EntryList[EntryCountMax];
        uint64_t m_CurrentDate;
    };

}}}
