﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/album/album_ImageOrientation.h>
#include "capsrv_ScreenShotOrientation.h"

namespace nn{ namespace capsrv{

    //! @brief nn::album::ImageOrientation を対応する nn::capsrv::ScreenShotOrientation に変換します。
    //! @param[in] src 変換元の nn::album::ImageOrientation の値
    //! @pre src は nn::album::ImageOrientation で定義されている値
    //! @return src に対応する ScreenShotOrientation の値を返します。
    inline ScreenShotOrientation ConvertImageOrientationToScreenShotOrientation(nn::album::ImageOrientation src) NN_NOEXCEPT
    {
        switch(src)
        {
        case nn::album::ImageOrientation_None:
            return ScreenShotOrientation_Default;
        case nn::album::ImageOrientation_Rotate90:
            return ScreenShotOrientation_Rotate90;
        case nn::album::ImageOrientation_Rotate180:
            return ScreenShotOrientation_Rotate180;
        case nn::album::ImageOrientation_Rotate270:
            return ScreenShotOrientation_Rotate270;
        default: NN_UNEXPECTED_DEFAULT;
        }
    }

    //! @brief nn::capsrv::ScreenShotOrientation を対応する nn::album::ImageOrientation に変換します。
    //! @param[in] src 変換元の ScreenShotOrientation の値
    //! @pre src は ScreenShotOrientation で定義されている値
    //! @return src に対応する nn::album::ImageOrientation の値を返します。
    inline nn::album::ImageOrientation ConvertScreenShotOrientationToImageOrientation(ScreenShotOrientationType src) NN_NOEXCEPT
    {
        switch(src)
        {
        case ScreenShotOrientation_Default:
            return nn::album::ImageOrientation_None;
        case ScreenShotOrientation_Rotate90:
            return nn::album::ImageOrientation_Rotate90;
        case ScreenShotOrientation_Rotate180:
            return nn::album::ImageOrientation_Rotate180;
        case ScreenShotOrientation_Rotate270:
            return nn::album::ImageOrientation_Rotate270;
        default: NN_UNEXPECTED_DEFAULT;
        }
    }

}}
