﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{

    namespace detail{
        typedef uint64_t AlbumMovieWriteStreamHandleType;
    }

    //! @brief アルバムへの動画書込みストリームのハンドルです。
    class AlbumMovieWriteStreamHandle
    {
    public:
        //! @brief デフォルトコンストラクタです。
        //! @details
        //! 無効なハンドルを作成します。
        AlbumMovieWriteStreamHandle() NN_NOEXCEPT
        {
            m_Value = 0;
        }

        explicit AlbumMovieWriteStreamHandle(detail::AlbumMovieWriteStreamHandleType value) NN_NOEXCEPT
        {
            m_Value = value;
        }

        bool operator==(const AlbumMovieWriteStreamHandle& v) const NN_NOEXCEPT
        {
            return m_Value == v.m_Value;
        }

        bool operator!=(const AlbumMovieWriteStreamHandle& v) const NN_NOEXCEPT
        {
            return m_Value != v.m_Value;
        }

        detail::AlbumMovieWriteStreamHandleType GetInnerValue() const NN_NOEXCEPT
        {
            return m_Value;
        }

    private:
        detail::AlbumMovieWriteStreamHandleType m_Value;
    };

}}
