﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdio>
#include <map>

#include <nn/ssl/detail/ssl_BuiltinDataInfo.h>

using namespace std;
using namespace nn::ssl::detail;

class CppHeaderWriter
{
private:
    static const char           *g_pBoilerplateHeader;
    static const char           *g_pAutoGenHeader;
    static const char           *g_pAutoGenFooter;
    static const char           *g_pEnumStartFmt;
    static const char           *g_pEnumEnd;
    static const char           *g_pEnumEntryFmt;
    static const char           *g_pEnumValAllFmt;
    static const int            g_MaxEnumLineLength = 256;
    static const char           g_pSkipChars[];

    static char MakeUpper(char in);

    static int MakeEnumName(char       *pOutBuf,
                            size_t     bufSize,
                            const char *pInName);

    static int WriteEnumEntry(FILE            *pOutFile,
                              const char      *pEnumName,
                              BuiltinDataInfo *pInfo);

public:
    static int DoWrite(FILE                             *pOutFile,
                       const char                       *pEnumName,
                       map<uint32_t, BuiltinDataInfo *> *pBdiMap);
};
