﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdio>
#include <map>

#include <nn/ssl/detail/ssl_BuiltinDataInfo.h>

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xmlmemory.h>
#include <libxml/xmlstring.h>

#include "util.h"

using namespace std;
using namespace nn::ssl;
using namespace nn::ssl::detail;

class FileLoader : public BuiltinDataLoader
{
private:
    char                        m_pFilePath[AppConstants::g_MaxPathLen];
    uint32_t                    m_dataSize;

public:
    explicit FileLoader(const char *pFilePath);
    ~FileLoader();

    //  Parent class methods
    uint32_t GetDataBufSize();
    int Load(uint8_t *pBuf, uint32_t maxBufSize, uint32_t *pOutDataSize);
};


class BuiltinDataDescrParser
{
private:
    const char                  *m_pRoot;
    FILE                        *m_pInFile;
    xmlDocPtr                   m_pXmlDoc;

    BuiltinDataInfo *ParseCertificateElement(xmlNsPtr pNs, xmlNodePtr pNode);
    BuiltinDataInfo *ParseCrlElement(xmlNsPtr pNs, xmlNodePtr pNode);

public:
    static const xmlChar        *g_NnSdkNamespaceUrl;
    static const xmlChar        *g_ElementBuiltin;
    static const xmlChar        *g_ElementCertificate;
    static const xmlChar        *g_ElementCrl;
    static const xmlChar        *g_AttrId;
    static const xmlChar        *g_AttrStatus;
    static const xmlChar        *g_AttrName;
    static const xmlChar        *g_AttrFilename;

    BuiltinDataDescrParser(const char *pInRoot, FILE *pInFile);
    ~BuiltinDataDescrParser();

    int Initialize();
    void Finalize();
    map<uint32_t, BuiltinDataInfo *> *BuildBuiltinDataMap();

    static void DestroyBuiltinDataMap(map<uint32_t, BuiltinDataInfo *> *pMap);
};
