﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SettingsManager
{
    using Nintendo.ToolFoundation.CommandLine;
    using Properties;

    /// <summary>
    /// コマンドの共通オプションです。
    /// </summary>
    internal sealed class CommonOptions
    {
        /// <summary>
        /// CommonArgs クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal CommonOptions()
        {
            this.Platform = Platform.Windows;

            this.Target = null;
        }

        /// <summary>
        /// プラットフォームを返します。
        /// </summary>
        internal Platform Platform { get; private set; }

        /// <summary>
        /// 指定された開発機を返します。
        /// </summary>
        internal string Target { get; private set; }

        /// <summary>
        /// コマンドラインパーサに自身を登録します。
        /// </summary>
        /// <param name="context">コマンドを構築するコンテキストです。</param>
        internal void RegiserWith(
            DelegateBasedCommandLineParser.CommandInfoBuildContext context)
        {
            context
                .AddFlagOption('r', "remote", this.AcceptRemoteOption)
                .SetDescription(Resources.CommonOptionRemote);

            context
                .AddValueOption('t', "target", this.AcceptTargetOption)
                .SetDescription(Resources.CommonOptionTarget);
        }

        private void AcceptRemoteOption()
        {
            this.Platform = Platform.Horizon;
        }

        private void AcceptTargetOption(string target)
        {
            this.AcceptRemoteOption();

            this.Target = target;
        }
    }
}
