﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace MakeFirmwareDebugSettings
{
    using System.Collections.Generic;
    using Nintendo.ToolFoundation.CommandLine;

    internal sealed class ProgramArgument
    {
        List<string> settingsFilePaths = new List<string>();

        internal string SettingsName { get; private set; } = string.Empty;

        internal string OutputFilePath { get; private set; } = string.Empty;

        internal string[] SettingsFilePaths
        {
            get
            {
                return this.settingsFilePaths.ToArray();
            }
        }

        internal void RegiserWith(DelegateBasedCommandLineParser parser)
        {
            parser.AddValueOption('n', "name", this.SetSettingsName)
                .SetDescription("specifies the settings name")
                .SetRequired();

            parser.AddValueOption('o', "output", this.SetOutputFilePath)
                .SetDescription("specifies the output file")
                .SetRequired();

            parser.AddValueOption('s', "settings", this.AppendSettingsFilePath)
                .SetDescription("specifies the settings file")
                .SetRequired();
        }

        private void SetSettingsName(string value)
        {
            this.SettingsName = value;
        }

        private void SetOutputFilePath(string value)
        {
            this.OutputFilePath = value;
        }

        private void AppendSettingsFilePath(string value)
        {
            this.settingsFilePaths.Add(value);
        }
    }
}
