﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using CommandUtility;
using Nintendo.Foundation.IO;

namespace MakeSignedBinary.Commands
{
    public class RemoveSignCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input file")]
        public string InputFile { get; set; }

        [CommandLineOption('o', "output", Description = "output file", IsRequired = true)]
        public string OutputFile { get; set; }

        [CommandLineOption('k', "key", Description = "input key file", IsRequired = true)]
        public string KeyConfigFile { get; set; }

        public override int Run()
        {
            var keyConfig = KeyConfig.Load(KeyConfigFile);

            Utility.RemoveSignBinary(keyConfig, OutputFile, InputFile);

            return 0;
        }
    }
}
