﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace MakeInitialImage
{
#if false
    public class NintendoSdkPath
    {
        private const string NintendoSdkRootMarkFileName = "NintendoSdkRootMark";

        public static string GetToolPath(string toolName)
        {
            switch (toolName)
            {
                case "MakeFatImage":
                    return Path.Combine(GetSdkRoot(), @"Programs\Chris\Outputs\Win32\Tools\MakeInitialImage\MakeFatImage\Develop\MakeFatImage.exe");
                case "InstallNcaOnHost":
                    return Path.Combine(GetSdkRoot(), @"Programs\Chris\Outputs\Win32\Tools\MakeInitialImage\InstallNcaOnHost\Develop\InstallNcaOnHost.exe");
                default:
                    throw new FileNotFoundException("{0} is not found.", toolName);
            }
        }

        public static string GetSdkRoot()
        {
            return FindRoot(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location));
        }

        public static string FindRoot(string path)
        {
            string startPath = path;
            string currentDirectory = startPath;
            string rootDirectory = Path.GetPathRoot(currentDirectory);

            while (rootDirectory != currentDirectory)
            {
                string rootMarkFilePath = System.IO.Path.Combine(currentDirectory, NintendoSdkRootMarkFileName);
                if (System.IO.File.Exists(rootMarkFilePath))
                {
                    return currentDirectory;
                }

                currentDirectory = System.IO.Path.GetFullPath(System.IO.Path.Combine(currentDirectory, ".."));
            }

            throw new InvalidDataException(string.Format("{0} を見つけられませんでした。\nPath=\n{1}", NintendoSdkRootMarkFileName, startPath));
        }

    }
#endif
}
