﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CommandUtility;
using Nintendo.Foundation.IO;
using System.IO;
using YamlDotNet;
using System.Security.Cryptography;
using System.Text.RegularExpressions;
using MakeInitialImage;

namespace Commands
{
    public class GetInfoCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input file")]
        public string InputFile { get; set; }

        public override int Run()
        {
            var inputFile = new FileInfo(InputFile);

            using (var reader = inputFile.OpenRead())
            {
                var gpt = new GuidPartitionTableReader(reader);

                Console.WriteLine(
$@"Header:
    Signature:      0x{gpt.GptHeader.Signature:X16}
    Revision:       0x{gpt.GptHeader.Revision:X8}
    HeaderSize:     {gpt.GptHeader.HeaderSize}
    HeaderCrc32:    0x{gpt.GptHeader.HeaderCrc32:X8}
    MyLba:          {gpt.GptHeader.MyLba}
    AlternateLba:   {gpt.GptHeader.AlternateLba}
    FirstUsableLba: {gpt.GptHeader.FirstUsableLba}
    LastUsableLba:  {gpt.GptHeader.LastUsableLba}
    DiskGuid:       {gpt.GptHeader.DiskGuid}
    PartitionEntryLba:         {gpt.GptHeader.PartitionEntryLba}
    NumberOfPartitionEntries:  {gpt.GptHeader.NumberOfPartitionEntries}
    SizeOfPartitionEntry:      {gpt.GptHeader.SizeOfPartitionEntry}
    PartitionEntryArrayCrc32:  0x{gpt.GptHeader.PartitionEntryArrayCrc32:X8}

Partitions:");

                foreach(var target in gpt.PartitionEntries.Select((partition, index) => new {partition = partition, index = index}))
                {
                    var index = target.index;
                    var partition = target.partition;

                    Console.WriteLine(
$@"    Partition[{index}]
        PartitionName: {partition.PartitionName}
        PartitionTypeGuid: {partition.PartitionTypeGuid}
        UniquePartitionGuid: {partition.UniquePartitionGuid}
        StartingLba: {partition.StartingLba}
        EndingLba: {partition.EndingLba}
        Attribute: {partition.Attributes}");
                }
            }

            return 0;
        }
    }
}
