﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//#include <curl/curl.h>
#include <cstdlib>
#include <string>
#include <vector>
#include <unordered_map>

#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/fs.h>
#include <nn/fs/fs_Host.h>
#include <nn/fs/fs_ResultHandler.h>
#include <nn/fs/fs_GameCard.h>
#include <nn/os.h>
#include <nn/init.h>

#include <nn/apm/apm_Lib.h>
#include <nn/idle/idle_SystemApi.h>

#include <nn/ncm/ncm_SubmissionPackageInstallTask.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentManagementUtil.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_ApplyDeltaTask.h>

#include <nn/ns/ns_ApplicationManagerApi.h>

#include "DevMenuCommand_Common.h"
#include "DevMenuCommand_InstallUtil.h"

using namespace nn;

namespace {

const size_t HeapByteSize = 20 * 1024 * 1024;
const size_t MallocBytesSize = 20 * 1024 * 1024;

const size_t CacheBufferSize = 1 * 1024 * 1024;
uint8_t s_CacheBuffer[CacheBufferSize];

}

nn::Result InstallNsp(const char* nspPath)
{
    ncm::StorageContentMetaKey installedKey;
    ncm::StorageContentMetaKey* outInstalledKey = &installedKey;
    int maxOutCount = 1;
    bool value;
    bool* outValue = &value;
    ncm::ContentMetaType type = ncm::ContentMetaType::Unknown;

    auto storage = ncm::StorageId::BuildInUser;
    auto onlyPush = false;

    NN_RESULT_DO(nn::ns::DeleteRedundantApplicationEntity());

    bool forceUpdate = true;
    bool skipInvalidateCache = false;
    int64_t detachTime = 0;

    auto pathString = std::string(nspPath);
    auto path = pathString.c_str();
    if (!devmenuUtil::IsNspFile(path))
    {
        NN_ABORT("Skip %s since it is not .nsp file.\n", path);
    }

    int readCount = 0;
    int readCountOne;
    bool success;
    NN_RESULT_DO(devmenuUtil::InstallCommonOne(&success, &outInstalledKey[readCount], &readCountOne, maxOutCount - readCount, path, storage, type, onlyPush, forceUpdate, skipInvalidateCache, detachTime));
    if (!success)
    {
        NN_ABORT("Aborted since failed to install %s.\n", path);
    }

    *outValue = true;
    NN_RESULT_SUCCESS;
} // NOLINT(impl/function_size)
