﻿using System;
using System.Collections.Generic;
using System.Net;

namespace Nintendo.Htcs
{
    public static class HtcsProxy
    {
        public static event Action OnTargetManagerConnect
        {
            add { HtcsProxyImpl.Instance.OnTargetManagerConnect += value; }
            remove { HtcsProxyImpl.Instance.OnTargetManagerConnect -= value; }
        }

        public static event Action OnTargetManagerDisconnect
        {
            add { HtcsProxyImpl.Instance.OnTargetManagerConnect += value; }
            remove { HtcsProxyImpl.Instance.OnTargetManagerConnect -= value; }
        }

        public static event Action<List<Target>> OnTargetListUpdate
        {
            add { HtcsProxyImpl.Instance.OnTargetListUpdate += value; }
            remove { HtcsProxyImpl.Instance.OnTargetListUpdate -= value; }
        }

        public static event Action<List<PortMapItem>> OnPortMapUpdate
        {
            add { HtcsProxyImpl.Instance.OnPortMapUpdate += value; }
            remove { HtcsProxyImpl.Instance.OnPortMapUpdate -= value; }
        }

        public static HtcsInfo HtcsInfo
        {
            get { return HtcsProxyImpl.Instance.HtcsInfo; }
        }

        public static bool Connected
        {
            get { return HtcsProxyImpl.Instance.Connected; }
        }

        public static void Start()
        {
            HtcsProxyImpl.Instance.Start();
        }

        public static void Stop()
        {
            HtcsProxyImpl.Instance.Stop();
        }

        public static int RegisterPortMap(HtcsEndPoint htcsEndPoint, IPEndPoint ipEndPoint)
        {
            return RegisterPortMap(
                new PortMapItem(htcsEndPoint, ipEndPoint));
        }

        public static int RegisterPortMap(PortMapItem item)
        {
            return HtcsProxyImpl.Instance.RegisterPortMap(item);
        }

        public static int UnregisterPortMap(string serviceName)
        {
            return UnregisterPortMap(
                new HtcsEndPoint(HtcsPeerName.Any, serviceName));
        }

        public static int UnregisterPortMap(HtcsEndPoint endPoint)
        {
            return HtcsProxyImpl.Instance.UnregisterPortMap(endPoint);
        }

        public static IPEndPoint QueryIPEndPoint(HtcsEndPoint endPoint)
        {
            return HtcsProxyImpl.Instance.QueryIPEndPoint(endPoint);
        }

        public static IPEndPoint QueryIPEndPoint(string PortName)
        {
            return HtcsProxyImpl.Instance.QueryIPEndPoint(PortName);
        }

        public static HtcsEndPoint QueryHtcsEndPoint(IPEndPoint endPoint)
        {
            return HtcsProxyImpl.Instance.QueryHtcsEndPoint(endPoint);
        }
    }
}
