﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Net;
using System.Net.Sockets;

namespace Nintendo.HtcTools.NintendoSdkDaemon
{
    public class Program
    {
        private const int HtclowListenPort = 20180;

        private static TimeSpan RetryInterval = TimeSpan.FromSeconds(1);

        public static void Main(string[] args)
        {
            if (args.Length != 1)
            {
                Console.WriteLine("Usage: NintendoSdkDaemon.exe <target IP address>");
                Environment.Exit(1);
            }
            string server = args[0];

            Task.Run(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"Try to connect {server} ...");

                        var tcpClient = new TcpClient(server, HtclowListenPort);

                        Console.WriteLine("Established.");

                        var htclowClient = new HtclowClient(tcpClient.GetStream());
                        var htcfsService = new HtcfsService(htclowClient);

                        Console.WriteLine("HtcfsService started.");

                        htcfsService.WaitServiceTask();

                        Console.WriteLine("HtcfsService finished.");
                    }
                    catch (SocketException)
                    {
                        Task.Delay(RetryInterval.Milliseconds).Wait();
                    }
                }
            }).Wait();
        }
    }
}
