﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Runtime.CompilerServices;

using System.IO;

namespace Nintendo.HtcTools.HtcfsLibrary
{
    internal static class Util
    {
        public const int MaxPathLength = 768;

        public static bool IsNativeResultSuccess(int nativeResult)
        {
            return nativeResult == 0;
        }

        public static byte[] ReceivePathFrom(Stream stream, long length)
        {
            if (length < 0 || length > MaxPathLength)
            {
                throw new HtcfsException($"Path length ({length}) is incorrect.");
            }

            var buffer = new byte[length + 1];

            var receivedSize = stream.Read(buffer, 0, (int)length);

            if (receivedSize != (int)length)
            {
                throw new HtcfsException($"Failed to receive enough path data.");
            }

            buffer[length] = (byte)'\0';

            return buffer;
        }
    }
}
