﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools.HtcfsLibrary
{
    [Serializable]
    internal class OutOfHandleException : Exception
    {
    }

    /// <summary>
    /// ハンドルのアロケーションを行うユーティリティクラス
    /// </summary>
    internal class HandleAllocator
    {
        // フリーリストへの要素の代入は具象クラスのコンストラクタで行う
        private IList<int> freeList = new List<int>();

        public HandleAllocator(int maxHandleCount)
        {
            for (int i = 0; i < maxHandleCount; i++)
            {
                Free(i);
            }
        }

        public int Allocate()
        {
            if (!freeList.Any())
            {
                throw new OutOfHandleException();
            }

            var handle = freeList.First();
            freeList.Remove(handle);
            return handle;
        }

        public void Free(int handle)
        {
            if (freeList.Contains(handle))
            {
                return;
            }

            freeList.Add(handle);
        }
    }
}
