﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools.HtcTmProxy
{
    internal class TmAutoConnectHeader
    {
        private const int HeaderSize = 16;
        private const int TmAutoConnectVersion = 1;

        private readonly byte[] m_Buffer = new byte[HeaderSize];

        public TmAutoConnectHeader(int port)
        {
            var tick = DateTime.Now.Ticks;
            var span = new Span<byte>(m_Buffer).NonPortableCast<byte, int>();

            span[0] = TmAutoConnectVersion; // version
            span[1] = (int)tick;            // time low
            span[2] = (int)(tick >> 32);    // time high
            span[3] = port;                 // port
        }

        public byte[] GetBytes()
        {
            return m_Buffer;
        }

        public int GetLength()
        {
            return HeaderSize;
        }
    }
}
