﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "OpusInfo.h"
#include "OpusMultiStreamInfo.h"

namespace Nintendo {
namespace CodecTool {

OpusMultiStreamInfo::OpusMultiStreamInfo()
{
    type = OpusHeaderType_MultiStreamInfo;
    size = 0;
    channelCount = 0;
    totalStreamCount = 0;
    stereoStreamCount = 0;
    padding = 0;
    channelMapping = nullptr;
}

void OpusMultiStreamInfo::WriteHeader(System::IO::BinaryWriter^ writer)
{
    writer->Write(type);
    writer->Write(size);
    //writer->Write(channelCount); // BasicInfo に含まれるので、ここでの書き出しはしない。
    writer->Write(totalStreamCount);
    writer->Write(stereoStreamCount);
    writer->Write(padding);
    for (auto i = 0; i < channelCount; ++i)
    {
        writer->Write(channelMapping[i]);
    }
}

}  // namespace CodecTool
}  // namespace Nintendo
