﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace Nintendo {
namespace CodecTool {

/// <summary>
/// Opus ヘッダ内の基本情報です。
/// </summary>
public ref class OpusBasicInfo
{
private:
    property int type;                          // 情報タイプ
    property int size;                          // サイズ
    property signed char version;               // バージョン情報
public:
    property signed char channelCount;          // チャンネル数
    property short frameDataSize;               // 1 フレームのバイトサイズ（VBR, CVBR の場合は 0）
    property int sampleRate;                    // サンプルレート
    property int dataInfoOffset;                // Opus データ本体の、ファイル先頭位置からのオフセット
    property int frameDataOffsetInfoOffset;     // フレームデータオフセット情報の、ファイル先頭位置からのオフセット（存在しなければ 0）
    property int contextInfoOffset;             // コンテキスト情報のファイル先頭からのオフセット（存在しなければ 0）
    property short preskipSampleCount;          // スキップカウント
    property short padding2;

    OpusBasicInfo();
    /// <summary>
    /// 基本情報を writer に書き込みます。
    /// </summary>
    void WriteHeader(System::IO::BinaryWriter^ writer);
};

}  // namespace CodecTool
}  // namespace Nintendo
