﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.Authoring.AuthoringEditor.SelectTwoNspFilesWindow
{
    public enum ComparableFileType
    {
        NotSet,
        NotFound,
        Unknown,
        NotOriginalAppNspFile,
        //
        Detecting,
        //
        AppNsp,
        AocNsp,
        PatchNsp,
        PatchNspExtractedDirectory,
        AppMeta,
        AocMeta,
    }

    public static class ComparableFileTypeExtensions
    {
        public static bool IsNsp(this ComparableFileType t) =>
            t == ComparableFileType.AppNsp ||
            t == ComparableFileType.AocNsp ||
            t == ComparableFileType.PatchNsp ||
            t == ComparableFileType.PatchNspExtractedDirectory;

        public static bool IsMeta(this ComparableFileType t) =>
            t == ComparableFileType.AppMeta ||
            t == ComparableFileType.AocMeta;

        public static bool IsPatch(this ComparableFileType t) =>
            t == ComparableFileType.PatchNsp ||
            t == ComparableFileType.PatchNspExtractedDirectory;

        public static bool IsComparable(this ComparableFileType t0, ComparableFileType t1) =>
            // ApplicationMeta 同士
            (t0 == ComparableFileType.AppMeta && t1 == ComparableFileType.AppMeta) ||
            // AocMeta 同士
            (t0 == ComparableFileType.AocMeta && t1 == ComparableFileType.AocMeta) ||
            // AocNsp 同士
            (t0 == ComparableFileType.AocNsp && t1 == ComparableFileType.AocNsp) ||
            // PatchNsp 同士
            (t0 == ComparableFileType.PatchNsp && t1 == ComparableFileType.PatchNsp) ||
            (t0 == ComparableFileType.PatchNspExtractedDirectory && t1 == ComparableFileType.PatchNspExtractedDirectory) ||
            // AppNsp 同士
            (t0 == ComparableFileType.AppNsp && t1 == ComparableFileType.AppNsp) ||
            // Patch と Nsp
            (t0 == ComparableFileType.AppNsp && t1 == ComparableFileType.PatchNsp) ||
            (t0 == ComparableFileType.PatchNsp && t1 == ComparableFileType.AppNsp) ||
            // PatchExtractedDirectory と Patch および Nsp
            (t0 == ComparableFileType.AppNsp && t1 == ComparableFileType.PatchNspExtractedDirectory) ||
            (t0 == ComparableFileType.PatchNspExtractedDirectory && t1 == ComparableFileType.AppNsp) ||
            (t0 == ComparableFileType.PatchNsp && t1 == ComparableFileType.PatchNspExtractedDirectory) ||
            (t0 == ComparableFileType.PatchNspExtractedDirectory && t1 == ComparableFileType.PatchNsp);
    }
}
