﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Globalization;
using System.Windows.Data;
using System.Windows.Media;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.NspEntriesWindow
{
    public class FileEntryLabelForegroundConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is NspFileModifiedType modifiedType))
            {
                return Colors.Black;
            }
            switch (modifiedType)
            {
                case NspFileModifiedType.Unknown:
                    return Colors.Black;
                case NspFileModifiedType.Changed:
                    return Colors.MediumSlateBlue;
                case NspFileModifiedType.Added:
                    return Colors.HotPink;
                case NspFileModifiedType.Removed:
                    return Colors.OrangeRed;
                default:
                    throw new ArgumentOutOfRangeException();
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
