﻿using System;
using System.Collections.Generic;
using System.Linq;
using BezelEditor.Mvvm;
using Livet;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class SelectionParamVm : ParamVm
    {
        public SelectionChoiceVm[] Choices { get; set; }

        public SelectionParamVm(string captionTag, string commentTag, IReactiveProperty property,
            IEnumerable<object> choices, Func<object, string> captionFormat)
            : base(captionTag, commentTag, property)
        {
            Choices = choices
                .Select(o =>
                    {
                        var c = new SelectionChoiceVm(o, captionFormat)
                        {
                            IsChecked = {Value = o == Property.Value},
                            IsReadOnly = IsReadOnly
                        };

                        c.IsChecked.Subscribe(i =>
                        {
                            if (_isInUpdateChoices)
                                return;

                            if (i)
                                Property.Value = o;

                            UpdateChoices();
                        }).AddTo(CompositeDisposable);

                        return c;
                    }
                ).ToArray();

            CompositeDisposable.Add(() => Choices.ForEach(c => c.Dispose()));

            UpdateChoices();
        }

        private bool _isInUpdateChoices;

        private void UpdateChoices()
        {
            if (Choices == null)
                return;

            using (new AnonymousDisposable(() => _isInUpdateChoices = false))
            {
                _isInUpdateChoices = true;

                foreach (var c in Choices)
                    c.IsChecked.Value = (int) c.Value == (int) Property.Value;
            }
        }
    }

    public class SelectionChoiceVm : ViewModelBase
    {
        public object Value { get; }
        public ReactiveProperty<bool> IsChecked { get; }
        public ReactiveProperty<bool> IsReadOnly { get; set; }

        public string Caption { get; }

        public SelectionChoiceVm(object value, Func<object, string>  captionFormat)
        {
            Value = value;
            IsChecked = new ReactiveProperty<bool>().AddTo(CompositeDisposable);

            Caption = captionFormat == null
                ? value.ToString()
                : captionFormat(value);
        }
    }

}
