﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.IO;
using System.Reactive.Linq;
using BezelEditor.Foundation.Utilities;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class FileOpenerVm : ParamVm
    {
        public ReactiveCommand<string> OpenCommand { get; }

        public bool OpenAsExplorer { get; set; }

        public FileOpenerVm(string captionTag, IReactiveProperty property) :
            base(captionTag, null, property)
        {
            var rp = (ReactiveProperty<string>) property;

            OpenCommand = rp
                .Select(x => File.Exists(x) || Directory.Exists(x)).ToReactiveCommand<string>()
                .AddTo(CompositeDisposable);

            OpenCommand
                .Subscribe(x =>
                {
                    if (File.Exists(x))
                    {
                        if (OpenAsExplorer)
                        {
                            WindowsUtility.OpenFileByExplorer(x);
                        }
                        else
                        {
                            using (var process = new Process())
                            {
                                process.StartInfo.FileName = x;
                                process.StartInfo.UseShellExecute = true;
                                process.Start();
                            }
                        }
                    }
                    else
                    {
                        WindowsUtility.OpenFolderByExplorer(x);
                    }
                })
                .AddTo(CompositeDisposable);
        }
    }
}
