﻿using System;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class BoolTwoSelectionParamVm : ParamVm
    {
        public string TrueCaption => Resources.ResourceManager.GetString(_TrueCaptionTag, Resources.Culture);
        public string FalseCaption => Resources.ResourceManager.GetString(_FalseCaptionTag, Resources.Culture);

        private readonly string _TrueCaptionTag;
        private readonly string _FalseCaptionTag;

        public BoolTwoSelectionParamVm(string captionTag, string commentTag, IReactiveProperty property,
            string trueCaptionTag, string falseCaptionTag
        )
            : base(captionTag, commentTag, property)
        {
            CultureService.Instance.ObserveProperty(x => x.Resources)
                .Subscribe(_ =>
                    {
                        // ReSharper disable ExplicitCallerInfoArgument
                        RaisePropertyChanged(nameof(TrueCaption));
                        RaisePropertyChanged(nameof(FalseCaption));
                        // ReSharper restore ExplicitCallerInfoArgument
                    }
                ).AddTo(CompositeDisposable);

            _TrueCaptionTag = trueCaptionTag;
            _FalseCaptionTag = falseCaptionTag;
        }
    }
}
