﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Controls
{
    public class PageListBox : ListBox
    {
        #region Caption

        public string Caption
        {
            get { return (string) GetValue(CaptionProperty); }
            set { SetValue(CaptionProperty, value); }
        }

        public static readonly DependencyProperty CaptionProperty =
            DependencyProperty.Register(
                nameof(Caption),
                typeof(string),
                typeof(PageListBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(string),
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region HasErrors

        public bool HasErrors
        {
            get { return (bool) GetValue(HasErrorsProperty); }
            set { SetValue(HasErrorsProperty, value); }
        }

        public static readonly DependencyProperty HasErrorsProperty =
            DependencyProperty.Register(
                nameof(HasErrors),
                typeof(bool),
                typeof(PageListBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(bool),
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region Icon

        public Brush Icon
        {
            get { return (Brush) GetValue(IconProperty); }
            set { SetValue(IconProperty, value); }
        }

        public static readonly DependencyProperty IconProperty =
            DependencyProperty.Register(
                nameof(Icon),
                typeof(Brush),
                typeof(PageListBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(Brush),
                    BindsTwoWayByDefault = true
                }
            );

        #endregion
    }
}
