﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Media;
using System.Globalization;

namespace Nintendo.Authoring.AuthoringEditor.Controls
{
    // https://www.codeproject.com/Articles/24973/TreeListView を参考に実装しました

    public class TreeListView : TreeView
    {
        static TreeListView()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(TreeListView),
                new FrameworkPropertyMetadata(typeof(TreeListView)));
        }

        #region Columns

        public GridViewColumnCollection Columns
        {
            get { return (GridViewColumnCollection) GetValue(ColumnsProperty); }
            set { SetValue(ColumnsProperty, value); }
        }

        public static readonly DependencyProperty ColumnsProperty =
            DependencyProperty.Register(
                nameof(Columns),
                typeof(GridViewColumnCollection),
                typeof(TreeListView),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = null,
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        public TreeListView()
        {
            Columns = new GridViewColumnCollection();
        }
    }

    public class TreeListViewExpander : ToggleButton
    {
    }

    public class TreeListViewConverter : IValueConverter
    {
        public const double IndentWidth = 24;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null)
                return null;

            var element = value as DependencyObject;

            var level = -1;

            for (; element != null; element = VisualTreeHelper.GetParent(element))
                if (element is TreeViewItem)
                    level++;

            return new Thickness(IndentWidth * level, 0, 0, 0);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
