﻿using System;
using System.IO;
using BezelEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class NintendoSdkHelper
    {
        public static PathString ApplicationMetaFilePath
        {
            get
            {
                var sdkRootPath = SdkRootPath;

                if (sdkRootPath == null)
                    return null;

                var paths = new []
                {
                    // .nmeta
                    @"Resources\SpecFiles\Application.aarch64.lp64.nmeta",
                    @"Programs\Iris\Resources\SpecFiles\Application.aarch64.lp64.nmeta",
                    // .meta
                    @"Resources\SpecFiles\Application.aarch64.lp64.meta",
                    @"Programs\Iris\Resources\SpecFiles\Application.aarch64.lp64.meta",
                };

                foreach (var path in paths)
                {
                    var metaFilePath = Path.Combine(sdkRootPath, path);
                    if (File.Exists(metaFilePath))
                    {
                        return metaFilePath;
                    }
                }

                return null;
            }
        }

        public static PathString ApplicationDescFilePath
        {
            get
            {
                var sdkRootPath = SdkRootPath;

                if (sdkRootPath == null)
                    return null;

                var path1 = Path.Combine(sdkRootPath, @"Resources\SpecFiles\Application.desc");
                if (File.Exists(path1))
                    return path1;

                var path2 = Path.Combine(sdkRootPath, @"Programs\Iris\Resources\SpecFiles\Application.desc");
                if (File.Exists(path2))
                    return path2;

                return null;
            }
        }

        public static PathString ApplicationIconPath
        {
            get
            {
                var sdkRootPath = SdkRootPath;

                if (sdkRootPath == null)
                    return null;

                var path1 = Path.Combine(sdkRootPath, @"Resources\SpecFiles\NintendoSDK_Application.bmp");
                if (File.Exists(path1))
                    return path1;

                var path2 = Path.Combine(sdkRootPath, @"Programs\Iris\Resources\SpecFiles\NintendoSDK_Application.bmp");
                if (File.Exists(path2))
                    return path2;

                return null;
            }
        }

        public static string MakeMetaExe
        {
            get
            {
                var sdkRoot = SdkRootPath;
                if (sdkRoot != null)
                    return Path.Combine(sdkRoot, @"Tools\CommandLineTools\MakeMeta\MakeMeta.exe");
                return null;
            }
        }

        public static PathString SdkRootPath => NintendoSdkRootPathByRootmark ?? NintendoSdkRootPathByEnvVar;

        private static string NintendoSdkRootPathByRootmark
        {
            get
            {
                var rootDir = Path.GetDirectoryName(AppDomain.CurrentDomain.BaseDirectory);
                // ReSharper disable once ConditionIsAlwaysTrueOrFalse
                if (rootDir == null)
                    return null;

                while (File.Exists(Path.Combine(rootDir, "NintendoSdkRootMark")) == false)
                {
                    rootDir = Path.GetDirectoryName(rootDir);
                    // ReSharper disable once ConditionIsAlwaysTrueOrFalse
                    if (rootDir == null)
                        return null;
                }

                // SDK 開発ツリーの場合はユーザー環境でないとみなし null を返し、環境変数が優先的使われるようにする
                if (File.Exists(Path.Combine(rootDir, "SigloRootMark")))
                {
                    // TODO: SDK 開発ツリーで作業を完結させる手順がまとまったらこれは消す
                    return null;
                }

                return rootDir;
            }
        }

        private static string NintendoSdkRootPathByEnvVar
        {
            get
            {
                var nintendoSdkRootEnv = Environment.GetEnvironmentVariable("NINTENDO_SDK_ROOT");
                return nintendoSdkRootEnv?.ToDirectoryPathString();
            }
        }
    }
}
